#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>

#define TOTAL_QUESTOES 50
#define TOTAL_TIPOS 5

/* Cria todos os diretórios no caminho até o arquivo */
int criar_diretorios_recursivamente(const char* caminho_completo) {
	char buffer[512];
	size_t i, len;
	
	if (!caminho_completo) return 0;

	len = strlen(caminho_completo);
	if (len >= sizeof(buffer)) return 0;

	strncpy(buffer, caminho_completo, sizeof(buffer));
	buffer[len] = '\0';

	for (i = 1; i < len; i++) {
		if (buffer[i] == '/') {
			buffer[i] = '\0';
			if (strlen(buffer) > 0) {
				if (mkdir(buffer, 0777) != 0 && errno != EEXIST) {
					return 0;
				}
			}
			buffer[i] = '/';
		}
	}
	/* Tenta criar o diretório pai final, caso o caminho termine com arquivo */
	const char* ultima_barra = strrchr(buffer, '/');
	if (ultima_barra) {
		size_t dir_len = ultima_barra - buffer;
		if (dir_len > 0) {
			char dir_final[512];
			if (dir_len >= sizeof(dir_final)) return 0;
			strncpy(dir_final, buffer, dir_len);
			dir_final[dir_len] = '\0';
			if (mkdir(dir_final, 0777) != 0 && errno != EEXIST) {
				return 0;
			}
		}
	}
	return 1;
}

struct Questao {
    const char* texto;
    int tipo;
    const char* sinal;
};

int main(int argc, char* argv[]) {
    struct Questao questoes[TOTAL_QUESTOES] = {
        {"Sou o centro das atenções, pois raramente me estresso, e gosto de conversas divertidas com os outros.", 1, "+"},
        {"Gosto de trabalhar sozinho, pois acredito que as acidentes da vida tem um sentido positivo.", 2, "-"},
        {"Estou sempre preparado para os desafios impostos pela realidade criada por Deus, achando divertido colocar idéias em prática.", 3, "+"},
        {"Gosto de expressar a raiva honestamente para não ficar doente mental, e viver mais.", 4, "-"},
        {"Gosto de ser respondido com a verdade falada e escrita, para me curar de pecados capitais, e viver mais.", 5, "+"},
        {"Falo pouco, assim mantenho o ambiente pacífico, e evito guerras com objetivos imperialistas.", 1, "-"},
        {"Tenho interesse pelas pessoas, pois acredito que elas são naturalmente boas, e vejo erros como acidentes.", 2, "+"},
        {"Busco fazer apenas as coisas que considero mais importante, como desobedecer minha imaginação", 3, "-"},
        {"Sou tranquilo na maior parte do tempo, tendo facilidade de relaxar, e sou resistente ao estresse.", 4, "+"},
        {"Sou uma pessoa que gosta de ordem, para que não ocorram guerras imperialistas, e defendo o que é certo.", 5, "-"},
        {"Sinto-me à vontade com pessoas, pois trabalho duro e sou recompensado por bens materiais por pessoas justas.", 1, "+"},
        {"Gosto de expressar todos os meus sentimentos, sou bem humorada, gosto de trocar idéias intensamente, e surpreendo.", 2, "-"},
        {"Presto atenção aos detalhes, cumpro as promessas que faço perdendo noites, seguindo o seu próprio caminho.", 3, "+"},
        {"Tenho facilidade de relaxar, e resolvo os problemas que posso, e que são os mais antigos.", 4, "-"},
        {"Tenho imaginação vívida, e desobedeço ela enquanto estou soberbo, desobedecendo ordens imorais de superiores deste mundo.", 5, "+"},
        {"Prefiro ficar em segundo plano, assim escuto mais, e consigo colocar as idéias em prática.", 1, "-"},
        {"Consigo me colocar no lugar dos dos outros, chorando de tristeza e dor por quem não se libertou da inveja, rezando Salmos.", 2, "+"},
        {"Busco fazer apenas as coisas que considero mais importante, como obedecer à Deus, ou seja, desobedecer minha imaginação.", 3, "-"},
        {"Vivo alegre à maior parte do tempo, e gostaria de me alegrar com as maldades que cometi, e com os acidentes que sofri.", 4, "+"},
        {"Sou um pensador apaixonado, que se adapta facilmente à cultura do país onde estiver, mesmo sendo um estrangeiro.", 5, "-"},
        {"Gosto de iniciar conversas, para ser o centro das atenções, expresso a raiva honestamente, e alerto para um possível acidente.", 1, "+"},
        {"Gosto de trabalhar sozinho, pois me arrependerei se as coisas e meus planos derem errado.", 2, "-"},
        {"Faço as tarefas logo que possível, antes que os problemas aumentem e fujam de controle.", 3, "+"},
        {"Sou facilmente perturbado, mas sob moderação consigo canalizar estes sentimento na forma de arte.", 4, "-"},
        {"Tenho ótimas ideias, como elogiar as pessoas para animá-las e falar Salmos para que elas se animem, riem, e se arrependem.", 5, "+"},
        {"Tenho pouco a dizer, assim escuto mais, consigo namorar facilmente se for minha vocação, e não sofrer de inveja", 1, "-"},
        {"Tenho um coração bondoso, mas preciso aprender a dizer não às propostas de maldades, se quiser me santificar.", 2, "+"},
        {"Sou uma pessoa criativa, flexível, e que gosta de liberdade.", 3, "-"},
        {"Busco melhorar o mundo, por meio: da arte, da música, das lágrimas de tristeza e dor por quem sofre de inveja, e por uma forte bússola moral.", 4, "-"},
        {"Sou uma pessoa que gosta de ordem, sou um pensador apaixonado, tenho facilidade de viver como estrangeiro em outra monarquia.", 5, "-"},
        {"Falo com várias pessoas em festas, pois dificilmente me estresso com as pessoas com soberba que falam o que suas imaginações sugerem falar.", 1, "+"},
        {"Gosto de trabalhar sozinho, pois gosto de colocar em prática as idéias faladas e escritas, na realidade criada por Deus.", 2, "-"},
        {"Gosto de fazer tarefas de forma rápida e eficiente, obtendo maior sucesso financeiro, evitando caos e guerras imperialistas.", 3, "+"},
        {"Detecto problemas e oportunidades de melhorias facilmente.", 4, "-"},
        {"Entendo as coisas com rapidez, permitindo colocá-las em prática se souber como obedece à Deus.", 5, "+"},
        {"Evito chamar atenção para mim, assim dificilmente sou alvo das maldades cometidas por pessoas que não rezaram Salmos contra a inveja.", 1, "-"},
        {"Tiro um tempo para os outros, com a finalidade de fazer para Deus e para os outros, o que gostariam que fizessem para mim.", 2, "+"},
        {"Preciso elogiar à Deus, à mim, e aos outros com frequência, pois quero ser responsável igual aos bons governantes e clérigos.", 3, "-"},
        {"Reflito sobre os meus sentimentos, de forma a aumentar o autoconhecimento, rezando Salmos contra 3 sentimentos, e uma oração contra a Soberba.", 4, "-"},
        {"Uso palavras difíceis, precisas, e profundas, porém preciso adaptá-las de acordo com a pessoa com que falo.", 5, "+"},
        {"Não me importo em ser o centro das atenções, pois dificilmente me estresso se estiver rodeado de pessoas sem inveja e me elogiando sinceramente.", 1, "+"},
        {"Sinto as emoções dos outros, de forma que consigo chorar de tristeza e dor por quem: sofre de inveja e, conseqüentemente, corre o risco de suicidar.", 2, "+"},
        {"Sigo uma rotina, pois falo bem de mim, de Deus, e dos outros, cumpro as tarefas importantes, e nas horas vagas faço leitura e meditação.", 3, "+"},
        {"Detesto consumo desnecessário de recursos na vida pessoal e profissional, e erradico por meio de elogios sinceros e Salmos o comportamento preguiçoso.", 4, "-"},
        {"Gosto de refletir sobre as coisas, julgo pouco os outros, choro de tristeza e dor por quem sofre de inveja, e surgem idéias originais.", 5, "+"},
        {"Sou quieto com estranhos, sou muito criativo, se bem instruído percebo expressões faciais ao ponto de detectar mentiras facilmente.", 1, "-"},
        {"Faço as pessoas se sentirem à vontade, sou retribuído com gentileza por quem não sofre de inveja, colaboro no trabalho.", 2, "+"},
        {"Gosto de distribuir trabalhos de acordo com as habilidades reais de quem os possui, e mudo de idéia se demonstrar que estou errado.", 3, "+"},
        {"Choro de tristeza por quem sofre de inveja, oferecendo apoio emocional, material, prevenindo acidentes, e me expressando em artes.", 4, "-"},
        {"Tenho muitas idéias como: rezar contra a soberba e se manter humilde, e obedecer à Deus e se manter invicto no que faz.", 5, "+"}
    };

    const char* ajuda =
        "Descreva-se como você é geralmente agora, e não como gostaria de ser no futuro.\n"
        "Seja honesto, comparando-se com outras pessoas do mesmo sexo e idade.\n"
        "Suas respostas serão mantidas em sigilo absoluto.\n\n"
        "Para cada afirmação, escolha a resposta que melhor descreve você:\n"
        "1. Muito Incorreta\n"
        "2. Moderadamente Incorreta\n"
        "3. Nem Correta Nem Incorreta\n"
        "4. Moderadamente Correta\n"
        "5. Muito Correta\n";

    const char* tipos[TOTAL_TIPOS] = {
        "Extroversão",
        "Amabilidade",
        "Conscienciosidade",
        "Estabilidade Emocional",
        "Intelecto/Imaginação"
    };

    int escores[TOTAL_TIPOS] = {0, 0, 0, 0, 0};
    int i, resposta;

    printf("Bem-vindo ao Teste de Personalidade IPIP (Big Five)!\n");
    printf("Total de %d questões.\n\n", TOTAL_QUESTOES);
    printf("%s", ajuda);
    printf("\nPressione Enter para começar...\n");
    getchar();

    for (i = 0; i < TOTAL_QUESTOES; i++) {
        int valido = 0;
        while (!valido) {
            char entrada[10];
            printf("\nQuestão %d:\n%s\nSua resposta (1-5): ", i + 1, questoes[i].texto);
            fgets(entrada, sizeof(entrada), stdin);

            if (entrada[0] == 'h' || entrada[0] == 'H') {
                printf("\n***** AJUDA *****\n%s\n", ajuda);
                continue;
            }

            if (isdigit(entrada[0])) {
                resposta = atoi(entrada);
                if (resposta >= 1 && resposta <= 5) {
                    int valor = 0;
                    if (strcmp(questoes[i].sinal, "+") == 0) {
                        valor = resposta;
                    } else {
                        valor = 6 - resposta;
                    }
                    escores[questoes[i].tipo - 1] += valor;
                    valido = 1;
                } else {
                    printf("Erro: digite um número entre 1 e 5.\n");
                }
            } else {
                printf("Entrada inválida. Digite um número de 1 a 5 ou 'help'.\n");
            }
        }
    }
    const char* caminho;
    if (argc >= 2 && argv[1][0] != '\0') {
	    caminho = argv[1]; /* usa o caminho passado como parâmetro */
    } else {
	    caminho = "resultados.txt"; /* caminho padrao */
    }
    
    if (!criar_diretorios_recursivamente(caminho)) {
	    printf("Erro ao criar o diretório para o caminho \"%s\".\n", caminho);
    } else {
	    FILE* arquivo = fopen(caminho, "w");
	    if (arquivo == NULL) {
		    printf("Erro ao salvar o arquivo em \"%s\". Verifique o caminho e permissoes.\n", caminho);
	    } else {
		    for (i = 0; i < TOTAL_TIPOS; i++) {
			    printf("%s: %d pontos\n", tipos[i], escores[i]);
			    fprintf(arquivo, "%s: %d pontos\n", tipos[i], escores[i]);
		    }
		    fclose(arquivo);
		    printf("\nOs resultados foram salvos em: %s\n", caminho);
	    }
    }

    return 0;
}
