/*
 * Copyright (C) 2016 Canon Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY CANON INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL CANON INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// @conditional=ENABLE(FETCH_API)

function initializeFetchHeaders(headersInit)
{
    "use strict";

    if (headersInit === @undefined)
        return this;

    if (!@isObject(headersInit))
        throw new @TypeError("headersInit must be an object");

    if (headersInit instanceof this.constructor) {
        this.@fillFromJS(headersInit);
        return this;
    }

    if (@isArray(headersInit)) {
        for (let i = 0; i < headersInit.length; i++) {
            let header = headersInit[i];
            if (header.length !== 2)
                throw new @TypeError("headersInit sequence items should contain two values");
            this.@appendFromJS(header[0], header[1]);
        }
        return this;
    }

    let propertyNames = @Object.@getOwnPropertyNames(headersInit);
    for (let i = 0; i < propertyNames.length; ++i) {
        let name = propertyNames[i];
        this.@appendFromJS(name, headersInit[name]);
    }

    return this;
}
