/*
 * drivers/video/sun4i/disp/de_bsp/de/ebios/de_be.c
 *
 * (C) Copyright 2007-2012
 * Allwinner Technology Co., Ltd. <www.allwinnertech.com>
 * Danling <danliang@allwinnertech.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include "de_be.h"
#include "de_fe.h"

__u32 image_reg_base[2] = {0,0};//DISE_REGS_BASE;

__u32  csc_tab[192] = 
{
    //Y/G   Y/G      Y/G      Y/G      U/R      U/R     U/R        U/R     V/B      V/B       V/B       V/B
    //bt601
    0x04a7,0x1e6f,0x1cbf,0x0877,0x04a7,0x0000,0x0662,0x3211,0x04a7,0x0812,0x0000,0x2eb1,//yuv2rgb
    0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000,//yuv2yuv
    0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000,//rgb2rgb
    0x0204,0x0107,0x0064,0x0100,0x1ed6,0x1f68,0x01c1,0x0800,0x1e87,0x01c1,0x1fb7,0x0800,//rgb2yuv

    //bt709
    0x04a7,0x1f25,0x1ddd,0x04cf,0x04a7,0x0000,0x072c,0x307d,0x04a7,0x0875,0x0000,0x2dea,//yuv2rgb
    0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000,//yuv2yuv
    0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000,//rgb2rgb
    0x0274,0x00bb,0x003f,0x0100,0x1ea5,0x1f98,0x01c1,0x0800,0x1e67,0x01c1,0x1fd7,0x0800,//rgb2yuv

    //DISP_YCC
    0x0400,0x1e9e,0x1d24,0x087b,0x0400,0x0000,0x059b,0x34c8,0x0400,0x0715,0x0000,0x31d4,//yuv2rgb
    0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000,//yuv2yuv
    0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000,//rgb2rgb
    0x0258,0x0132,0x0075,0x0000,0x1eac,0x1f53,0x0200,0x0800,0x1e53,0x0200,0x1fac,0x0800,//rgb2yuv

    //xvYCC
    0x04a7,0x1f25,0x1ddd,0x04cf,0x04a7,0x0000,0x072c,0x307d,0x04a7,0x0875,0x0000,0x2dea,//yuv2rgb
    0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000,//yuv2yuv
    0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000,//rgb2rgb
    0x0274,0x00bb,0x003f,0x0100,0x1ea5,0x1f98,0x01c1,0x0800,0x1e67,0x01c1,0x1fd7,0x0800 //rgb2yuv
};

__u32  image_enhance_tab[224] = 
{
    //csc convert table
    0x00000107,0x00000204,0x00000064,0x00004000,0xffffff69,0xfffffed7,0x000001c1,0x00020000,
    0x000001c1,0xfffffe88,0xffffffb8,0x00020000,0x00000000,0x00000000,0x00000000,0x00000400,
    0x000004a7,0x00000000,0x00000662,0xfffc845b,0x000004a7,0xfffffe70,0xfffffcc0,0x00021df3,
    0x000004a7,0x00000812,0x00000000,0xfffbac4a,0x00000000,0x00000000,0x00000000,0x00000400,
    
    0x000000bb,0x00000274,0x0000003f,0x00004000,0xffffff99,0xfffffea6,0x000001c1,0x00020000,
    0x000001c1,0xfffffe68,0xffffffd8,0x00020000,0x00000000,0x00000000,0x00000000,0x00000400,
    0x000004a7,0x00000000,0x0000072c,0xfffc1f7d,0x000004a7,0xffffff26,0xfffffdde,0x000133f7,
    0x000004a7,0x00000875,0x00000000,0xfffb7aa0,0x00000000,0x00000000,0x00000000,0x00000400,
    
    0x00000132,0x00000258,0x00000075,0x00000000,0xffffff54,0xfffffead,0x00000200,0x00020000,
    0x00000200,0xfffffe54,0xffffffad,0x00020000,0x00000000,0x00000000,0x00000000,0x00000400,
    0x00000400,0x00000000,0x0000059b,0xfffd3213,0x00000400,0xfffffe9f,0xfffffd25,0x00021ec5,
    0x00000400,0x00000715,0x00000000,0xfffc7540,0x00000000,0x00000000,0x00000000,0x00000400,
    //sin table
    0xffffffbd,0xffffffbf,0xffffffc1,0xffffffc2,0xffffffc4,0xffffffc6,0xffffffc8,0xffffffca,
    0xffffffcc,0xffffffce,0xffffffd1,0xffffffd3,0xffffffd5,0xffffffd7,0xffffffd9,0xffffffdb,
    0xffffffdd,0xffffffdf,0xffffffe2,0xffffffe4,0xffffffe6,0xffffffe8,0xffffffea,0xffffffec,
    0xffffffef,0xfffffff1,0xfffffff3,0xfffffff5,0xfffffff8,0xfffffffa,0xfffffffc,0xfffffffe,
    0x00000000,0x00000002,0x00000004,0x00000006,0x00000008,0x0000000b,0x0000000d,0x0000000f,
    0x00000011,0x00000014,0x00000016,0x00000018,0x0000001a,0x0000001c,0x0000001e,0x00000021,
    0x00000023,0x00000025,0x00000027,0x00000029,0x0000002b,0x0000002d,0x0000002f,0x00000032,
    0x00000034,0x00000036,0x00000038,0x0000003a,0x0000003c,0x0000003e,0x0000003f,0x00000041,
    //cos table
    0x0000006c,0x0000006d,0x0000006e,0x0000006f,0x00000071,0x00000072,0x00000073,0x00000074,
    0x00000074,0x00000075,0x00000076,0x00000077,0x00000078,0x00000079,0x00000079,0x0000007a,
    0x0000007b,0x0000007b,0x0000007c,0x0000007c,0x0000007d,0x0000007d,0x0000007e,0x0000007e,
    0x0000007e,0x0000007f,0x0000007f,0x0000007f,0x0000007f,0x0000007f,0x0000007f,0x0000007f,
    0x00000080,0x0000007f,0x0000007f,0x0000007f,0x0000007f,0x0000007f,0x0000007f,0x0000007f,
    0x0000007e,0x0000007e,0x0000007e,0x0000007d,0x0000007d,0x0000007c,0x0000007c,0x0000007b,
    0x0000007b,0x0000007a,0x00000079,0x00000079,0x00000078,0x00000077,0x00000076,0x00000075,
    0x00000074,0x00000074,0x00000073,0x00000072,0x00000071,0x0000006f,0x0000006e,0x0000006d
};

__u32  fir_tab[1792] = 
{
    0x00004000,0x000140ff,0x00033ffe,0x00043ffd,0x00063efc,0xff083dfc,0x000a3bfb,0xff0d39fb,
    0xff0f37fb,0xff1136fa,0xfe1433fb,0xfe1631fb,0xfd192ffb,0xfd1c2cfb,0xfd1f29fb,0xfc2127fc,
    0xfc2424fc,0xfc2721fc,0xfb291ffd,0xfb2c1cfd,0xfb2f19fd,0xfb3116fe,0xfb3314fe,0xfa3611ff,
    0xfb370fff,0xfb390dff,0xfb3b0a00,0xfc3d08ff,0xfc3e0600,0xfd3f0400,0xfe3f0300,0xff400100,
    0x00004000,0x000140ff,0x00033ffe,0x00043ffd,0x00063efc,0xff083dfc,0x000a3bfb,0xff0d39fb,
    0xff0f37fb,0xff1136fa,0xfe1433fb,0xfe1631fb,0xfd192ffb,0xfd1c2cfb,0xfd1f29fb,0xfc2127fc,
    0xfc2424fc,0xfc2721fc,0xfb291ffd,0xfb2c1cfd,0xfb2f19fd,0xfb3116fe,0xfb3314fe,0xfa3611ff,
    0xfb370fff,0xfb390dff,0xfb3b0a00,0xfc3d08ff,0xfc3e0600,0xfd3f0400,0xfe3f0300,0xff400100,
    0x00053704,0x00063703,0x00073702,0x00093601,0x000b3500,0x000c3400,0x000e3200,0x000f3100,
    0x00112f00,0x00132d00,0x00152b00,0x00162a00,0x00182800,0x001a2600,0x001c2400,0x001e2200,
    0x00202000,0x00211f00,0x00231d00,0x00251b00,0x00271900,0x00291700,0x002a1600,0x002c1400,
    0x002e1200,0x00301000,0x00310f00,0x00330d00,0x00340c00,0x01350a00,0x02360800,0x03360700,
    0x00083008,0x00093007,0x000b3005,0x000d2f04,0x000e2f03,0x00102e02,0x00112e01,0x00132d00,
    0x00142c00,0x00152b00,0x00172900,0x00182800,0x001a2600,0x001b2500,0x001d2300,0x001e2200,
    0x00202000,0x00211f00,0x00221e00,0x00241c00,0x00251b00,0x00271900,0x00281800,0x002a1600,
    0x002b1500,0x002d1300,0x012d1200,0x022e1000,0x032e0f00,0x042f0d00,0x052f0c00,0x072f0a00,
    0x000b2a0b,0x000d2a09,0x000e2a08,0x000f2a07,0x00102a06,0x00122905,0x00132904,0x00142903,
    0x00162802,0x00172702,0x00182701,0x001a2600,0x001b2500,0x001c2400,0x001d2300,0x001e2200,
    0x00202000,0x00211f00,0x00221e00,0x00231d00,0x00241c00,0x00261a00,0x01261900,0x02271700,
    0x02281600,0x03281500,0x04291300,0x05291200,0x06291100,0x072a0f00,0x082a0e00,0x092a0d00,
    0x000d270c,0x000f260b,0x0010260a,0x00112609,0x00122608,0x00122608,0x00132607,0x00152506,
    0x00162505,0x00172504,0x00192403,0x00192403,0x001b2302,0x001d2201,0x001d2201,0x001f2100,
    0x00202000,0x00211f00,0x01211e00,0x01221d00,0x02221c00,0x03231a00,0x03241900,0x04241800,
    0x05241700,0x06251500,0x07251400,0x08251300,0x08261200,0x09261100,0x0a261000,0x0b260f00,
    
    0x000e240e,0x000f240d,0x0010240c,0x0012230b,0x0013230a,0x0013230a,0x00142309,0x00152308,
    0x00162307,0x00182206,0x00182206,0x00192205,0x001b2104,0x001c2103,0x001d2003,0x011e1f02,
    0x021e1e02,0x021f1e01,0x03201d00,0x03211c00,0x04211b00,0x05211a00,0x06211900,0x06221800,
    0x07221700,0x08221600,0x09221500,0x0a221400,0x0a231300,0x0b231200,0x0c231100,0x0d231000,
    0x0010210f,0x0011210e,0x0012210d,0x0012210d,0x0013210c,0x0014210b,0x0015210a,0x0015210a,
    0x00162109,0x00182008,0x00182008,0x01191f07,0x011a1f06,0x021b1e05,0x021b1e05,0x031c1d04,
    0x031d1d03,0x041d1c03,0x051e1b02,0x051e1b02,0x061f1a01,0x071f1901,0x07201801,0x08201800,
    0x09201700,0x0a201600,0x0a211500,0x0b211400,0x0c211300,0x0d201300,0x0d211200,0x0e211100,
    0x00102010,0x0011200f,0x0012200e,0x0012200e,0x0013200d,0x00151f0c,0x00151f0c,0x01151f0b,
    0x01161e0b,0x01171e0a,0x02171e09,0x02181d09,0x03191d07,0x03191c08,0x041a1c06,0x041a1c06,
    0x051b1b05,0x061b1b04,0x061c1a04,0x071c1904,0x071d1903,0x081d1803,0x091d1802,0x091e1702,
    0x0a1e1602,0x0b1e1601,0x0c1f1500,0x0c1f1500,0x0d1f1400,0x0e1f1300,0x0e201200,0x0f1f1200,
    0x00111e11,0x00121e10,0x00131e0f,0x00131e0f,0x01131e0e,0x01141d0e,0x02151d0c,0x02151d0c,
    0x02161d0b,0x03161c0b,0x03171c0a,0x04171c09,0x04181b09,0x05181b08,0x05191b07,0x06191a07,
    0x061a1a06,0x071a1906,0x071b1905,0x081b1805,0x091b1804,0x091c1704,0x0a1c1703,0x0a1c1604,
    0x0b1d1602,0x0c1d1502,0x0c1d1502,0x0d1d1402,0x0e1d1401,0x0e1e1301,0x0f1e1300,0x101e1200,
    0x02121b11,0x02121b11,0x02131b10,0x03131b0f,0x03131b0f,0x04141a0e,0x04141a0e,0x04151a0d,
    0x05151a0c,0x05151a0c,0x0616190b,0x0616190b,0x0616190b,0x0716190a,0x0717180a,0x08171809,
    0x08181808,0x09181708,0x09181708,0x0a181707,0x0a191607,0x0b191606,0x0b191606,0x0c1a1505,
    0x0c1a1505,0x0d1a1504,0x0d1a1405,0x0e1a1404,0x0f1a1403,0x0f1b1303,0x101b1302,0x101b1203,
    0x04121911,0x04121911,0x05121910,0x05121910,0x0513190f,0x0613180f,0x0614180e,0x0614180e,
    0x0714180d,0x0714180d,0x0715180c,0x0815170c,0x0815170c,0x0915170b,0x0915170b,0x0916160b,
    0x0a16160a,0x0a16160a,0x0b161609,0x0b161609,0x0b171509,0x0c171508,0x0c181507,0x0d171507,
    0x0d181407,0x0e181406,0x0e181406,0x0f181306,0x0f191305,0x10181305,0x10181305,0x10191205,
    
    0x06111811,0x06121711,0x06121711,0x06131710,0x0713170f,0x0713170f,0x0713170f,0x0813170e,
    0x0813170e,0x0814160e,0x0914160d,0x0914160d,0x0914160d,0x0a14160c,0x0a14160c,0x0a15150c,
    0x0b15150b,0x0b15150b,0x0c15150a,0x0c15150a,0x0c16140a,0x0d161409,0x0d161409,0x0d161409,
    0x0e161408,0x0e171308,0x0f171307,0x0f171307,0x0f171307,0x10171306,0x10171207,0x11171206,
    0x07121611,0x07121611,0x08121610,0x08121610,0x0813160f,0x0813160f,0x0912160f,0x0913160e,
    0x0913150f,0x0a13150e,0x0a14150d,0x0a14150d,0x0a14150d,0x0b13150d,0x0b14150c,0x0b14150c,
    0x0c14140c,0x0c15140b,0x0c15140b,0x0d14140b,0x0d15140a,0x0d15140a,0x0d15140a,0x0e15130a,
    0x0e15130a,0x0e161309,0x0f151309,0x0f161308,0x0f161308,0x10161208,0x10161208,0x10161208,
    0x0b111410,0x0b111410,0x0b111410,0x0b111410,0x0b121310,0x0b121310,0x0c12130f,0x0c12130f,
    0x0c12130f,0x0c12130f,0x0c12130f,0x0c12130f,0x0d12130e,0x0d12130e,0x0d12130e,0x0d12130e,
    0x0d13130d,0x0e12130d,0x0e13120d,0x0e13120d,0x0e13120d,0x0e13120d,0x0e13120d,0x0f13120c,
    0x0f13120c,0x0f13120c,0x0f13120c,0x0f13120c,0x1013120b,0x1013120b,0x1013120b,0x1014110b,
    0x0c111310,0x0c111211,0x0d111210,0x0d111210,0x0d111210,0x0d111210,0x0d111210,0x0d111210,
    0x0d111210,0x0d12120f,0x0d12120f,0x0e11120f,0x0e11120f,0x0e11120f,0x0e12120e,0x0e12120e,
    0x0e12120e,0x0e12120e,0x0e12120e,0x0f11120e,0x0f11120e,0x0f11120e,0x0f12120d,0x0f12120d,
    0x0f12110e,0x0f12110e,0x0f12110e,0x0f12110e,0x1012110d,0x1012110d,0x1012110d,0x1012110d,
    0x40000000,0x00000000,0x40fe0000,0x0000ff03,0x3ffd0000,0x0000ff05,0x3ffc0000,0x0000ff06,
    0x3efb0000,0x0000ff08,0x3dfb0000,0x0000ff09,0x3bfa0000,0x0000fe0d,0x39fa0000,0x0000fe0f,
    0x38fa0000,0x0000fe10,0x36fa0000,0x0000fe12,0x33fa0000,0x0000fd16,0x31fa0000,0x0000fd18,
    0x2ffa0000,0x0000fd1a,0x2cfa0000,0x0000fc1e,0x29fa0000,0x0000fc21,0x27fb0000,0x0000fb23,
    0x24fb0000,0x0000fb26,0x21fb0000,0x0000fb29,0x1ffc0000,0x0000fa2b,0x1cfc0000,0x0000fa2e,
    0x19fd0000,0x0000fa30,0x16fd0000,0x0000fa33,0x14fd0000,0x0000fa35,0x11fe0000,0x0000fa37,
    0x0ffe0000,0x0000fa39,0x0dfe0000,0x0000fa3b,0x0afe0000,0x0000fa3e,0x08ff0000,0x0000fb3e,
    0x06ff0000,0x0000fb40,0x05ff0000,0x0000fc40,0x03ff0000,0x0000fd41,0x01ff0000,0x0000fe42,
    //8 tap
    0x40000000,0x00000000,0x40fe0000,0x0000ff03,0x3ffd0000,0x0000ff05,0x3ffc0000,0x0000ff06,
    0x3efb0000,0x0000ff08,0x3dfb0000,0x0000ff09,0x3bfa0000,0x0000fe0d,0x39fa0000,0x0000fe0f,
    0x38fa0000,0x0000fe10,0x36fa0000,0x0000fe12,0x33fa0000,0x0000fd16,0x31fa0000,0x0000fd18,
    0x2ffa0000,0x0000fd1a,0x2cfa0000,0x0000fc1e,0x29fa0000,0x0000fc21,0x27fb0000,0x0000fb23,
    0x24fb0000,0x0000fb26,0x21fb0000,0x0000fb29,0x1ffc0000,0x0000fa2b,0x1cfc0000,0x0000fa2e,
    0x19fd0000,0x0000fa30,0x16fd0000,0x0000fa33,0x14fd0000,0x0000fa35,0x11fe0000,0x0000fa37,
    0x0ffe0000,0x0000fa39,0x0dfe0000,0x0000fa3b,0x0afe0000,0x0000fa3e,0x08ff0000,0x0000fb3e,
    0x06ff0000,0x0000fb40,0x05ff0000,0x0000fc40,0x03ff0000,0x0000fd41,0x01ff0000,0x0000fe42,
    0x3a05fefe,0x00fefe09,0x3a04fefe,0x00fefe0a,0x3a02fffe,0x00fefe0b,0x3901fffe,0x00fefd0e,
    0x3900fffe,0x00fefd0f,0x38fefffe,0x00fefd12,0x37fdfffe,0x00fefd14,0x36fcfffe,0x00fefc17,
    0x34fcffff,0x00fefc18,0x33fbffff,0x00fefc1a,0x31fbffff,0x00fefb1d,0x2ffbffff,0x00fefb1f,
    0x2dfaff00,0x00fefb21,0x2cfaff00,0x00fefb22,0x2afaff00,0x00fefa25,0x28faff00,0x00fefa27,
    0x25fafe00,0x00fefa2b,0x23fafe00,0x00fffa2c,0x21fafe00,0x00fffa2e,0x1ffbfe00,0x00fffa2f,
    0x1dfbfe00,0x00fffa31,0x1afbfe00,0x00fffb33,0x18fbfe00,0x00fffb35,0x16fcfe00,0x00fffb36,
    0x14fcfe00,0x00fffc37,0x12fcfe00,0x00fffc39,0x0ffdfe00,0x00fffd3a,0x0dfdfe00,0x00fffe3b,
    0x0cfdfe00,0x00ff003a,0x0afdfe00,0x00ff013b,0x08fefe00,0x00ff023b,0x06fefe00,0x00fe043c,
    0x3409fdfe,0x00fefd0d,0x3408fdfe,0x00fefc0f,0x3406fdfe,0x00fefc11,0x3405fdfe,0x00fefc12,
    0x3304fefe,0x00fefc13,0x3203fefe,0x00fefb16,0x3202fefe,0x00fefb17,0x3101fefe,0x00fffb18,
    0x3000fefe,0x00fffb1a,0x2ffefffe,0x00fffb1c,0x2dfefffe,0x00fffb1e,0x2cfdfffe,0x00fffb20,
    0x2bfcfffe,0x00fffb22,0x29fcfffe,0x00fffb24,0x28fcfffe,0x00fffb25,0x26fbfffe,0x00fffb28,
    0x24fbfffe,0x00fffb2a,0x23fbfffe,0x00fffb2b,0x21fbfffe,0x00fffc2c,0x1ffbffff,0x00fffc2d,
    0x1dfbffff,0x00fffc2f,0x1cfbffff,0x00fffd2f,0x1afbffff,0x00fffe30,0x18fbffff,0x00fffe32,
    0x16fbff00,0x00fe0032,0x14fbff00,0x00fe0133,0x13fbfe00,0x00fe0234,0x11fcfe00,0x00fe0334,
    0x0ffcfe00,0x00fe0435,0x0efcfe00,0x00fd0536,0x0cfcfe00,0x00fd0637,0x0bfcfe00,0x00fd0836,
    
    0x2f0cfcff,0x00fffc0f,0x2f0bfcff,0x00fffb11,0x2f0afcff,0x00fffb12,0x2e09fcfe,0x00fffb15,
    0x2e07fcfe,0x00fffb17,0x2d06fdfe,0x00fffb18,0x2d05fdfe,0x00fffb19,0x2c04fdfe,0x00fffb1b,
    0x2c03fdfe,0x00fffb1c,0x2b02fdfe,0x00fffb1e,0x2a01fefe,0x00fffb1f,0x2901fefe,0x00fffb20,
    0x2800fefe,0x00fffb22,0x27fefefe,0x00fffc24,0x26fefefe,0x00fffc25,0x24fdfefe,0x00fffc28,
    0x23fdfffe,0x00fffd27,0x22fcfffe,0x00fefd2a,0x21fcfffe,0x00fefe2a,0x1ffcfffe,0x00fefe2c,
    0x1efbfffe,0x00fe002c,0x1cfbfffe,0x00fe012d,0x1bfbfffe,0x00fe012e,0x19fbfffe,0x00fd0230,
    0x18fbfffe,0x00fd0330,0x16fbfffe,0x00fd0431,0x15fbfffe,0x00fd0531,0x13fbfffe,0x00fd0632,
    0x12fbfffe,0x00fc0733,0x10fbfffe,0x00fc0933,0x0ffbffff,0x00fc0a32,0x0efbffff,0x00fc0b32,
    0x2a0efbff,0x00fffb14,0x2a0dfbff,0x00fffb15,0x2a0cfcff,0x00fffb15,0x2a0bfcff,0x00fffb16,
    0x2a0afcff,0x00fffb17,0x2909fcff,0x00fffb19,0x2908fcff,0x00fffc19,0x2907fcff,0x00fffc1a,
    0x2806fcff,0x00fffc1c,0x2705fcff,0x00fffc1e,0x2704fdff,0x00fefc1f,0x2603fdff,0x00fefd20,
    0x2503fdff,0x00fefd21,0x2402fdfe,0x00fefe23,0x2401fdfe,0x00fefe24,0x2301fdfe,0x00fefe25,
    0x2200fefe,0x00fe0024,0x21fefefe,0x00fd0127,0x20fefefe,0x00fd0128,0x1ffefefe,0x00fd0228,
    0x1dfdfefe,0x00fd032a,0x1cfdfefe,0x00fd032b,0x1bfcfefe,0x00fd042c,0x1afcfffe,0x00fc052c,
    0x19fcfffe,0x00fc062c,0x17fcfffe,0x00fc072d,0x16fcfffe,0x00fc082d,0x15fbfffe,0x00fc092e,
    0x14fbfffe,0x00fc0a2e,0x12fbfffe,0x00fc0b2f,0x11fbfffe,0x00fb0c30,0x10fbfffe,0x00fb0d30,
    0x2710fcff,0x00fffc13,0x270ffcff,0x00fffc14,0x270efcff,0x00fffc15,0x270dfcff,0x00fffc16,
    0x260cfcff,0x00fefc19,0x260bfcff,0x00fefd19,0x260afcff,0x00fefd1a,0x2609fcff,0x00fefd1b,
    0x2508fcff,0x00fefd1d,0x2507fcff,0x00fefe1d,0x2407fcff,0x00fefe1e,0x2406fcff,0x00feff1e,
    0x2305fcff,0x00fd0020,0x2204fcff,0x00fd0022,0x2204fdff,0x00fd0120,0x2103fdff,0x00fd0221,
    0x2002fdff,0x00fd0223,0x1f02fdff,0x00fd0323,0x1e01fdff,0x00fd0424,0x1e00fdff,0x00fc0426,
    0x1d00fdff,0x00fc0526,0x1cfffeff,0x00fc0626,0x1bfefeff,0x00fc0727,0x1afefefe,0x00fc0729,
    0x19fdfefe,0x00fc082a,0x18fdfefe,0x00fc092a,0x17fdfefe,0x00fc0a2a,0x16fdfefe,0x00fc0b2a,
    0x14fcfefe,0x00fc0c2c,0x13fcfefe,0x00fc0d2c,0x12fcfffe,0x00fc0e2b,0x11fcfffe,0x00fc0f2b,
    
    0x2411fdfe,0x00fefd15,0x2410fcfe,0x00fefd17,0x240ffcfe,0x00fefd18,0x240efcfe,0x00fefd19,
    0x240efcff,0x00fefe17,0x240dfcff,0x00fefe18,0x230cfcff,0x00fdfe1b,0x230bfcff,0x00fdff1b,
    0x230afcff,0x00fd001b,0x2209fcff,0x00fd001d,0x2209fcff,0x00fd011c,0x2108fcff,0x00fd011e,
    0x2107fcff,0x00fd021e,0x2006fcff,0x00fd0220,0x2006fcff,0x00fc0320,0x1f05fcff,0x00fc0421,
    0x1f04fcff,0x00fc0422,0x1e04fcff,0x00fc0522,0x1d03fcff,0x00fc0623,0x1c02fdff,0x00fc0624,
    0x1c02fdff,0x00fc0723,0x1b01fdff,0x00fc0824,0x1a01fdff,0x00fc0924,0x1900fdff,0x00fc0926,
    0x1800fdff,0x00fc0a26,0x17fffdff,0x00fc0b27,0x17fefdff,0x00fc0c27,0x16fefeff,0x00fc0d26,
    0x15fefeff,0x00fc0e26,0x14fdfeff,0x00fc0e28,0x13fdfeff,0x00fc0f28,0x12fdfeff,0x00fc1028,
    0x2212fefe,0x00fefe14,0x2211fefe,0x00fdfe16,0x2210fdfe,0x00fdfe18,0x220ffdfe,0x00fdff18,
    0x220ffdfe,0x00fd0017,0x210efdfe,0x00fd0019,0x210dfdfe,0x00fd0119,0x210cfcfe,0x00fd011b,
    0x210cfcfe,0x00fd021a,0x200bfcfe,0x00fd021c,0x200afcfe,0x00fc031d,0x1f09fcff,0x00fc031e,
    0x1f09fcff,0x00fc041d,0x1f08fcff,0x00fc041e,0x1e07fcff,0x00fc051f,0x1e07fcff,0x00fc051f,
    0x1d06fcff,0x00fc0620,0x1c05fcff,0x00fc0721,0x1c05fcff,0x00fc0721,0x1b04fcff,0x00fc0822,
    0x1b04fcff,0x00fc0921,0x1a03fcff,0x00fc0923,0x1903fcff,0x00fc0a23,0x1802fdff,0x00fc0b23,
    0x1802fdff,0x00fc0b23,0x1701fdff,0x00fc0c24,0x1601fdff,0x00fd0d23,0x1500fdff,0x00fd0e24,
    0x1500fdff,0x00fd0e24,0x14fffdff,0x00fd0f25,0x13fefdff,0x00fd1026,0x12fefdff,0x00fe1125,
    0x201200fd,0x00fd0014,0x2011fffd,0x00fd0016,0x2011fefd,0x00fd0116,0x2010fefd,0x00fd0117,
    0x1f0ffefd,0x00fd0119,0x1f0ffefd,0x00fd0218,0x1f0efdfe,0x00fd0219,0x1f0dfdfe,0x00fc031a,
    0x1f0dfdfe,0x00fc031a,0x1e0cfdfe,0x00fc041b,0x1e0bfdfe,0x00fc041c,0x1e0bfdfe,0x00fc051b,
    0x1d0afdfe,0x00fc051d,0x1d09fdfe,0x00fc061d,0x1c09fcfe,0x00fc061f,0x1c08fcfe,0x00fc071f,
    0x1c07fcfe,0x00fc0720,0x1b07fcff,0x00fc081f,0x1b06fcff,0x00fc091f,0x1a06fcff,0x00fd091f,
    0x1905fcff,0x00fd0a20,0x1905fcff,0x00fd0a20,0x1804fcff,0x00fd0b21,0x1804fcff,0x00fd0c20,
    0x1703fcff,0x00fd0c22,0x1603fcff,0x00fd0d22,0x1602fdff,0x00fd0e21,0x1502fdff,0x00fe0e21,
    0x1401fdff,0x00fe0f22,0x1401fdff,0x00fe1021,0x1301fdff,0x00fe1022,0x1200fdff,0x00ff1122,
    
    0x1c1202fd,0x00fd0214,0x1c1202fd,0x00fd0313,0x1c1102fd,0x00fd0314,0x1c1001fd,0x00fd0415,
    0x1c1001fd,0x00fd0415,0x1c0f01fd,0x00fd0416,0x1b0f01fd,0x00fd0516,0x1b0e00fd,0x00fd0518,
    0x1b0e00fd,0x00fd0617,0x1b0dfffd,0x00fd0619,0x1b0dfffd,0x00fd0718,0x1a0cfefd,0x00fd071b,
    0x1a0cfefd,0x00fd071b,0x1a0bfefd,0x00fd081b,0x1a0afefd,0x00fd081c,0x190afefd,0x00fd091c,
    0x1909fdfe,0x00fd091d,0x1809fdfe,0x00fe0a1c,0x1808fdfe,0x00fe0a1d,0x1808fdfe,0x00fe0b1c,
    0x1707fdfe,0x00fe0b1e,0x1707fdfe,0x00fe0c1d,0x1606fdfe,0x00ff0c1e,0x1606fdfe,0x00ff0d1d,
    0x1606fdfe,0x00000d1c,0x1505fdfe,0x00000e1d,0x1505fdfe,0x00010f1b,0x1404fdfe,0x00010f1d,
    0x1404fdfe,0x0001101c,0x1303fdfe,0x0001101e,0x1303fdff,0x0002111b,0x1203fdff,0x0002111c,
    0x181104fd,0x00fd0415,0x181104fd,0x00fd0514,0x181104fd,0x00fd0514,0x181003fd,0x00fd0516,
    0x181003fd,0x00fd0615,0x180f03fd,0x00fd0616,0x180f02fd,0x00fe0715,0x180e02fd,0x00fe0716,
    0x180e02fd,0x00fe0716,0x180e02fd,0x00fe0815,0x180d01fd,0x00fe0817,0x170d01fd,0x00fe0818,
    0x170c01fd,0x00fe0918,0x170c01fd,0x00fe0918,0x170b00fd,0x00ff0a18,0x170b00fd,0x00ff0a18,
    0x160b00fd,0x00000b17,0x160afffd,0x00000b19,0x160afffd,0x00000b19,0x1609fefd,0x00010c19,
    0x1509fefd,0x00010c1a,0x1508fefd,0x00010d1a,0x1508fefd,0x00010d1a,0x1408fefd,0x00020d1a,
    0x1407fefd,0x00020e1a,0x1407fefe,0x00020e19,0x1306fefe,0x00020f1a,0x1306fdfe,0x00030f1a,
    0x1306fdfe,0x00031019,0x1205fdfe,0x0003101b,0x1205fdfe,0x0004101a,0x1205fdfe,0x00041119,
    0x161006fe,0x00fe0612,0x161005fe,0x00fe0613,0x161005fe,0x00fe0613,0x160f05fe,0x00fe0713,
    0x160f05fe,0x00fe0713,0x160f04fe,0x00ff0713,0x160f04fd,0x00ff0813,0x150e04fd,0x00ff0815,
    0x150e03fd,0x00000815,0x150e03fd,0x00000914,0x150d03fd,0x00000915,0x150d03fd,0x00010914,
    0x150c02fd,0x00010a15,0x150c02fd,0x00010a15,0x150c02fd,0x00010a15,0x150b02fd,0x00010b15,
    0x140b01fd,0x00010b17,0x140b01fd,0x00020b16,0x140a01fd,0x00020c16,0x140a01fd,0x00020c16,
    0x140a01fd,0x00020c16,0x130901fd,0x00030d16,0x130900fd,0x00030d17,0x130900fd,0x00030e16,
    0x130800fd,0x00030e17,0x1208fffd,0x00040e18,0x1208fffd,0x00040f17,0x1207fffd,0x00040f18,
    0x1207fefd,0x00050f18,0x1107fefd,0x00051018,0x1106fefd,0x00051019,0x1106fefd,0x00051019,
    
    0x140f0700,0x0000070f,0x140f06ff,0x00000711,0x140f06ff,0x00000711,0x140f06ff,0x00000810,
    0x130f06ff,0x00010810,0x140e05fe,0x00010812,0x130e05fe,0x00010813,0x130e05fe,0x00010912,
    0x130d05fe,0x00010913,0x130d04fe,0x00010914,0x130d04fe,0x00020a12,0x130d04fe,0x00020a12,
    0x130c04fe,0x00020a13,0x130c03fe,0x00020a14,0x130c03fe,0x00020b13,0x130c03fe,0x00030b12,
    0x130b03fe,0x00030b13,0x120b03fe,0x00030c13,0x120b02fd,0x00030c15,0x120a02fd,0x00030c16,
    0x120a02fd,0x00040c15,0x120a02fd,0x00040d14,0x120a02fd,0x00040d14,0x120901fd,0x00040d16,
    0x110901fd,0x00050e15,0x110901fd,0x00050e15,0x110901fd,0x00050e15,0x110801fd,0x00050f15,
    0x110801fd,0x00060f14,0x110800fd,0x00060f15,0x100700fd,0x00060f17,0x100700fd,0x00071015,
    0x120f0701,0x0001070f,0x120e0701,0x0001080f,0x120e0701,0x0001080f,0x120e0701,0x0001080f,
    0x120e0600,0x00020810,0x110e0600,0x00020910,0x120d0600,0x00020910,0x120d0600,0x00020910,
    0x120d0600,0x00020910,0x120d05ff,0x00020a11,0x120d05ff,0x00030a10,0x120c05ff,0x00030a11,
    0x120c05ff,0x00030a11,0x110c04ff,0x00030b12,0x110c04fe,0x00030b13,0x110c04fe,0x00040b12,
    0x110b04fe,0x00040b13,0x110b04fe,0x00040c12,0x110b03fe,0x00040c13,0x110b03fe,0x00040c13,
    0x110a03fe,0x00050c13,0x110a03fe,0x00050d12,0x110a03fe,0x00050d12,0x100a03fe,0x00050d13,
    0x100a02fe,0x00060d13,0x100902fe,0x00060e13,0x100902fe,0x00060e13,0x100902fe,0x00060e13,
    0x100902fe,0x00070e12,0x100802fe,0x00070f12,0x100801fe,0x00070f13,0x0f0801fd,0x00070f15,
    0x100e0802,0x0002080e,0x100e0802,0x0002080e,0x110e0702,0x0002080e,0x110d0702,0x0002080f,
    0x100d0701,0x0003090f,0x100d0701,0x0003090f,0x100d0701,0x0003090f,0x100d0601,0x00030910,
    0x100d0601,0x00030a0f,0x100c0601,0x00030a10,0x100c0601,0x00040a0f,0x100c0601,0x00040a0f,
    0x100c0500,0x00040a11,0x100c0500,0x00040b10,0x100c0500,0x00040b10,0x100b0500,0x00040b11,
    0x100b0500,0x00050b10,0x100b05ff,0x00050b11,0x100b04ff,0x00050c11,0x100b04ff,0x00050c11,
    0x100b04ff,0x00060c10,0x100a04ff,0x00060c11,0x100a04fe,0x00060d11,0x100a03fe,0x00060d12,
    0x0f0a03fe,0x00060d13,0x0f0a03fe,0x00070d12,0x0f0903fe,0x00070d13,0x0f0903fe,0x00070e12,
    0x0f0903fe,0x00070e12,0x0f0902fe,0x00080e12,0x0f0902fe,0x00080e12,0x0f0802fe,0x00080e13,
    
    0x0f0d0803,0x0003080e,0x0f0d0803,0x0003080e,0x0f0d0802,0x0003090e,0x0f0d0802,0x0003090e,
    0x0f0d0702,0x0003090f,0x0f0d0702,0x0003090f,0x0f0d0702,0x0004090e,0x0f0c0702,0x0004090f,
    0x0f0c0702,0x00040a0e,0x0f0c0702,0x00040a0e,0x0f0c0601,0x00040a10,0x0f0c0601,0x00040a10,
    0x0f0c0601,0x00050a0f,0x0e0c0601,0x00050b0f,0x0f0b0601,0x00050b0f,0x0f0b0601,0x00050b0f,
    0x0f0b0501,0x00050b10,0x0f0b0501,0x00060b0f,0x0f0b0501,0x00060b0f,0x0f0b0500,0x00060c0f,
    0x0f0b0500,0x00060c0f,0x0f0a0500,0x00060c10,0x0f0a0400,0x00070c10,0x0f0a0400,0x00070c10,
    0x0e0a0400,0x00070d10,0x0f0a04ff,0x00070d10,0x0f0a04ff,0x00070d10,0x0e0904ff,0x00080d11,
    0x0e0903ff,0x00080d12,0x0e0903ff,0x00080e11,0x0e0903ff,0x00080e11,0x0e0903fe,0x00080e12,
    0x0f0d0803,0x0003080e,0x0e0d0803,0x0004090d,0x0e0d0803,0x0004090d,0x0e0d0803,0x0004090d,
    0x0f0c0803,0x0004090d,0x0f0c0803,0x0004090d,0x0f0c0703,0x0004090e,0x0e0c0703,0x00040a0e,
    0x0e0c0702,0x00050a0e,0x0e0c0702,0x00050a0e,0x0e0c0702,0x00050a0e,0x0e0c0702,0x00050a0e,
    0x0e0b0702,0x00050a0f,0x0e0b0602,0x00050a10,0x0e0b0602,0x00060b0e,0x0e0b0602,0x00060b0e,
    0x0e0b0601,0x00060b0f,0x0e0b0601,0x00060b0f,0x0e0b0601,0x00060b0f,0x0e0b0501,0x00060b10,
    0x0e0a0501,0x00070c0f,0x0e0a0501,0x00070c0f,0x0e0a0501,0x00070c0f,0x0e0a0501,0x00070c0f,
    0x0e0a0501,0x00070c0f,0x0d0a0501,0x00080c0f,0x0e0a0400,0x00080d0f,0x0e0a0400,0x00080d0f,
    0x0e090400,0x00080d10,0x0e090400,0x00080d10,0x0e090400,0x00080d10,0x0e090400,0x00090d0f,
    0x0c0c0905,0x0005090c,0x0d0c0904,0x0005090c,0x0d0c0804,0x0005090d,0x0d0c0804,0x0005090d,
    0x0d0c0804,0x0005090d,0x0d0c0804,0x0005090d,0x0d0c0804,0x0005090d,0x0d0b0804,0x00050a0d,
    0x0c0b0804,0x00060a0d,0x0c0b0804,0x00060a0d,0x0d0b0703,0x00060a0e,0x0d0b0703,0x00060a0e,
    0x0d0b0703,0x00060a0e,0x0d0b0703,0x00060a0e,0x0d0b0703,0x00060a0e,0x0c0b0703,0x00070b0d,
    0x0c0b0703,0x00070b0d,0x0c0b0703,0x00070b0d,0x0d0b0603,0x00070b0d,0x0d0a0602,0x00070b0f,
    0x0d0a0602,0x00070b0f,0x0d0a0602,0x00070b0f,0x0d0a0602,0x00080b0e,0x0c0a0602,0x00080c0e,
    0x0c0a0602,0x00080c0e,0x0c0a0602,0x00080c0e,0x0c0a0602,0x00080c0e,0x0d0a0502,0x00080c0e,
    0x0c0a0502,0x00090c0e,0x0d090501,0x00090c0f,0x0d090501,0x00090c0f,0x0d090501,0x00090d0e,
    
    0x0c0b0905,0x0005090d,0x0c0b0905,0x0006090c,0x0c0b0905,0x0006090c,0x0c0b0905,0x0006090c,
    0x0c0b0805,0x0006090d,0x0c0b0805,0x0006090d,0x0c0b0805,0x0006090d,0x0c0b0805,0x00060a0c,
    0x0c0b0805,0x00060a0c,0x0c0b0804,0x00060a0d,0x0c0b0804,0x00070a0c,0x0c0b0804,0x00070a0c,
    0x0c0b0804,0x00070a0c,0x0c0b0804,0x00070a0c,0x0c0b0704,0x00070a0d,0x0c0b0704,0x00070a0d,
    0x0c0a0704,0x00070a0e,0x0c0a0704,0x00070b0d,0x0c0a0704,0x00070b0d,0x0c0a0703,0x00080b0d,
    0x0c0a0703,0x00080b0d,0x0c0a0703,0x00080b0d,0x0c0a0703,0x00080b0d,0x0c0a0703,0x00080b0d,
    0x0c0a0603,0x00080b0e,0x0c0a0603,0x00080b0e,0x0c0a0603,0x00090b0d,0x0b0a0603,0x00090c0d,
    0x0b0a0603,0x00090c0d,0x0b0a0603,0x00090c0d,0x0c090602,0x00090c0e,0x0c090602,0x00090c0e,
};

__s32 DE_Set_Reg_Base(__u32 sel, __u32 address)
{
	image_reg_base[sel] = address;
	// memset((void*)(image0_reg_base+0x800), 0,0x1000-0x800); 
	    	
	return 0;
}

__u32 DE_Get_Reg_Base(__u32 sel)
{

   return image_reg_base[sel];

}

__u32 DE_BE_Reg_Init(__u32 sel)
{
	memset((void*)(image_reg_base[sel]+0x800), 0,0x1000-0x800); 

	return 0;
}

__s32 DE_BE_Set_SystemPalette(__u32 sel, __u32 * pbuffer, __u32 offset,__u32 size)
{
	__u32 *pdest_end;
    __u32 *psrc_cur;
    __u32 *pdest_cur;

    if(size > DE_BE_PALETTE_TABLE_SIZE)
    {
        size = DE_BE_PALETTE_TABLE_SIZE;
    }
    
	psrc_cur = pbuffer;
	pdest_cur = (__u32*)(DE_Get_Reg_Base(sel)+DE_BE_PALETTE_TABLE_ADDR_OFF  + offset);
	pdest_end = pdest_cur + (size>>2);

    while(pdest_cur < pdest_end)
    {
    	*(volatile __u32 *)pdest_cur++ = *psrc_cur++;
    }
    
   return 0;
}

__s32 DE_BE_Get_SystemPalette(__u32 sel, __u32 *pbuffer, __u32 offset,__u32 size)
{
	__u32 *pdest_end;
    __u32 *psrc_cur;
    __u32 *pdest_cur;

    if(size > DE_BE_PALETTE_TABLE_SIZE)
    {
        size = DE_BE_PALETTE_TABLE_SIZE;
    }
	
	psrc_cur = (__u32*)(DE_Get_Reg_Base(sel)+DE_BE_PALETTE_TABLE_ADDR_OFF + offset);
	pdest_cur = pbuffer;
	pdest_end = pdest_cur + (size>>2);
	
    while(pdest_cur < pdest_end)
    {
    	*(volatile __u32 *)pdest_cur++ = *psrc_cur++;
    }

    return 0;	
}

__s32 DE_BE_Enable(__u32 sel)
{
    DE_BE_WUINT32(sel,DE_BE_MODE_CTL_OFF,DE_BE_RUINT32(sel, DE_BE_MODE_CTL_OFF) | (0x01<<1));//start
    DE_BE_WUINT32(sel,DE_BE_MODE_CTL_OFF,DE_BE_RUINT32(sel, DE_BE_MODE_CTL_OFF) | 0x01);//enable  
    
    return 0;
}   

__s32 DE_BE_Disable(__u32 sel)
{
    DE_BE_WUINT32(sel,DE_BE_MODE_CTL_OFF,DE_BE_RUINT32(sel, DE_BE_MODE_CTL_OFF) & 0xfffffffd);//reset
    DE_BE_WUINT32(sel,DE_BE_MODE_CTL_OFF,DE_BE_RUINT32(sel, DE_BE_MODE_CTL_OFF) & 0xfffffffe);//disable

    return 0;
} 

// 0:lcd0 only; 1:lcd1 only
// 2:lcd0+fe0; 3:lcd1+fe0
// 4:lcd0+fe1; 5:lcd1+fe1
// 6:fe0 only;  7:fe1 only
__s32 DE_BE_Output_Select(__u32 sel, __u32 out_sel)
{
    DE_BE_WUINT32(sel,DE_BE_MODE_CTL_OFF,(DE_BE_RUINT32(sel, DE_BE_MODE_CTL_OFF) & 0xff8fffff) | (out_sel << 20));//start

    if((out_sel == 6) || (out_sel == 7))
    {
        DE_BE_WUINT32(sel, DE_BE_ERROR_CORRECTION, 0xffffffff);
    }
    else
    {
        DE_BE_WUINT32(sel, DE_BE_ERROR_CORRECTION, 0);
    }

    return 0;
}   

__s32 DE_BE_Set_BkColor(__u32 sel, __disp_color_t bkcolor)
{
    DE_BE_WUINT32(sel,DE_BE_COLOR_CTL_OFF, (bkcolor.alpha<<24) | (bkcolor.red<<16) | (bkcolor.green<<8) | bkcolor.blue);

    return 0;
}

__s32 DE_BE_Set_ColorKey(__u32 sel, __disp_color_t ck_max,__disp_color_t  ck_min,__u32 ck_red_match, __u32 ck_green_match, __u32 ck_blue_match)
{
    DE_BE_WUINT32(sel,DE_BE_CLRKEY_MAX_OFF,(ck_max.alpha<<24) | (ck_max.red<<16) | (ck_max.green<<8) | ck_max.blue);
    DE_BE_WUINT32(sel,DE_BE_CLRKEY_MIN_OFF,(ck_min.alpha<<24) | (ck_min.red<<16) | (ck_min.green<<8) | ck_min.blue);
    DE_BE_WUINT32(sel,DE_BE_CLRKEY_CFG_OFF,(ck_red_match<<4) | (ck_green_match<<2) | ck_blue_match);
    
    return 0;
}

__s32 DE_BE_reg_auto_load_en(__u32 sel, __u32 en)
{
    __u32 tmp;
    
    tmp = DE_BE_RUINT32(sel, DE_BE_FRMBUF_CTL_OFF);
    DE_BE_WUINT32(sel, DE_BE_FRMBUF_CTL_OFF, tmp | ((1-en)<<1));//bit1:enable, bit0:ready
    
    return 0;
}

__s32 DE_BE_Cfg_Ready(__u32 sel)
{
    __u32 tmp;
    
    tmp = DE_BE_RUINT32(sel, DE_BE_FRMBUF_CTL_OFF);
    DE_BE_WUINT32(sel, DE_BE_FRMBUF_CTL_OFF, tmp | 0x1);//bit1:enable, bit0:ready
    
    return 0;
}


__s32 DE_BE_Sprite_Enable(__u32 sel, __bool enable)
{
	DE_BE_WUINT32(sel, DE_BE_SPRITE_EN_OFF,(DE_BE_RUINT32(sel, DE_BE_SPRITE_EN_OFF)&0xfffffffe) | enable);
	return 0;
}

__s32 DE_BE_Sprite_Disable(__u32 sel)
{
	DE_BE_WUINT32(sel, DE_BE_SPRITE_EN_OFF,DE_BE_RUINT32(sel, DE_BE_SPRITE_EN_OFF)&0xfffffffe);
	return 0;
}

__s32 DE_BE_Sprite_Set_Format(__u32 sel, __u8 pixel_seq,__u8 format)
{
	DE_BE_WUINT32(sel, DE_BE_SPRITE_FORMAT_CTRL_OFF,(pixel_seq<<12)|(format<<8));
	return 0;
}

__s32 DE_BE_Sprite_Global_Alpha_Enable(__u32 sel, __bool enable)
{
	DE_BE_WUINT32(sel, DE_BE_SPRITE_ALPHA_CTRL_OFF,enable);
	return 0;
}

__s32 DE_BE_Sprite_Set_Global_Alpha(__u32 sel, __u8 alpha_val)
{
    __u32 tmp;

    tmp = DE_BE_RUINT32(sel, DE_BE_SPRITE_ALPHA_CTRL_OFF);
    tmp = (tmp & 0x00ffffff) | (alpha_val << 24);
    
	DE_BE_WUINT32(sel, DE_BE_SPRITE_ALPHA_CTRL_OFF,tmp);
	return 0;
}      

__s32 DE_BE_Sprite_Block_Set_Pos(__u32 sel, __u8 blk_idx,__s16 x,__s16 y)
{	
  	DE_BE_WUINT32IDX(sel, DE_BE_SPRITE_POS_CTRL_OFF,blk_idx,((y&0xffff)<<16) | (x&0xffff));
   	return 0;
}

__s32 DE_BE_Sprite_Block_Set_Size(__u32 sel, __u8 blk_idx,__u32 xsize,__u32 ysize)//todo
{
	__u32 tmp = 0;

	tmp = DE_BE_RUINT32IDX(sel, DE_BE_SPRITE_ATTR_CTRL_OFF,blk_idx) & 0x0000003f;
	
	DE_BE_WUINT32IDX(sel, DE_BE_SPRITE_ATTR_CTRL_OFF,blk_idx,tmp | ((ysize-1)<<20) | ((xsize-1)<<8));
	return 0;
}

__s32 DE_BE_Sprite_Block_Set_fb(__u32 sel, __u8 blk_idx,__u32 addr, __u32 line_width)
{
	DE_BE_WUINT32IDX(sel, DE_BE_SPRITE_ADDR_OFF,blk_idx,addr);
	DE_BE_WUINT32IDX(sel, DE_BE_SPRITE_LINE_WIDTH_OFF,blk_idx, line_width<<3);
	return 0;
}

__s32 DE_BE_Sprite_Block_Set_Next_Id(__u32 sel, __u8 blk_idx,__u8 next_blk_id)
{
    __u32 tmp = 0;

    tmp = DE_BE_RUINT32IDX(sel, DE_BE_SPRITE_ATTR_CTRL_OFF,blk_idx) & 0xffffffc0;
	DE_BE_WUINT32IDX(sel, DE_BE_SPRITE_ATTR_CTRL_OFF,blk_idx,tmp | next_blk_id);
	return 0;
}

__s32 DE_BE_Sprite_Set_Palette_Table(__u32 sel, __u32 address, __u32 offset, __u32 size)
{
	__u32 *pdest_end;
    __u32 *psrc_cur;
    __u32 *pdest_cur;

    if(size > DE_BE_SPRITE_PALETTE_TABLE_SIZE)
    {
        size = DE_BE_SPRITE_PALETTE_TABLE_SIZE;
    }

	psrc_cur = (__u32*)address;
	pdest_cur = (__u32*)(DE_Get_Reg_Base(sel) + DE_BE_SPRITE_PALETTE_TABLE_ADDR_OFF + offset);
	pdest_end = pdest_cur + (size>>2);

    while(pdest_cur < pdest_end)
    {
    	*(volatile __u32 *)pdest_cur++ = *psrc_cur++;
    }
    
    return 0;	
}

//brightness -100~100
//contrast -100~100
//saturaion -100~100
__s32 DE_BE_Set_Enhance(__u8 sel,__u32 brightness, __u32 contrast, __u32 saturaion, __u32 hue)
{
	__s32 i_bright;
	__s32 i_contrast;
	__s32 i_saturaion;
	__s32 i_hue;	//fix
	__scal_matrix4x4 matrixEn;
	__scal_matrix4x4 matrixconv, *ptmatrix;
	__scal_matrix4x4 matrixresult;
	__s32 *pt;
	__u32 i;
	__s32 sinv, cosv;	//sin_tab: 7 bit fractional


	brightness = brightness>100?100:(brightness<0?0:brightness);
	contrast = contrast>100?100:(contrast<0?0:contrast);
	saturaion = saturaion>100?100:(saturaion<0?0:saturaion);
	
	i_bright = (__s32)(brightness*64/100);
	i_saturaion = (__s32)(saturaion*64/100);
	i_contrast = (__s32)(contrast*64/100);
	i_hue = (__s32)(hue*64/100);

	sinv = image_enhance_tab[8*12 + (i_hue&0x3f)];
	cosv = image_enhance_tab[8*12 + 8*8 + (i_hue&0x3f)];
	
	matrixEn.x00 = i_contrast << 5;
	matrixEn.x01 = 0;
	matrixEn.x02 = 0;
	matrixEn.x03 = (((i_bright - 32) + 16) <<10) - ( i_contrast << 9);
	matrixEn.x10 = 0;
	matrixEn.x11 = (i_contrast * i_saturaion * cosv) >> 7;
	matrixEn.x12 = (i_contrast * i_saturaion * sinv) >> 7;
	matrixEn.x13 = (1<<17) - ((matrixEn.x11 + matrixEn.x12)<<7);
	matrixEn.x20 = 0;
	matrixEn.x21 = (-i_contrast * i_saturaion * sinv)>>7;
	matrixEn.x22 = (i_contrast * i_saturaion * cosv) >> 7;
	matrixEn.x23 = (1<<17) - ((matrixEn.x22 + matrixEn.x21)<<7);
	matrixEn.x30 = 0;
	matrixEn.x31 = 0;
	matrixEn.x32 = 0;
	matrixEn.x33 = 1024;

	ptmatrix = (__scal_matrix4x4 *)((__u32)image_enhance_tab + (1<<7));
	iDE_SCAL_Matrix_Mul(matrixEn, *ptmatrix, &matrixconv);
	ptmatrix = (__scal_matrix4x4 *)((__u32)image_enhance_tab + (1<<7) + 0x40);
	iDE_SCAL_Matrix_Mul(*ptmatrix, matrixconv, &matrixconv);
	
	matrixresult.x00 = matrixconv.x01;	matrixresult.x01 = matrixconv.x00;
	matrixresult.x02 = matrixconv.x02;	matrixresult.x03 = matrixconv.x03;
	matrixresult.x10 = matrixconv.x11;	matrixresult.x11 = matrixconv.x10;
	matrixresult.x12 = matrixconv.x12;	matrixresult.x13 = matrixconv.x13;
	matrixresult.x20 = matrixconv.x21;	matrixresult.x21 = matrixconv.x20;
	matrixresult.x22 = matrixconv.x22;	matrixresult.x23 = matrixconv.x23;
	matrixresult.x30 = matrixconv.x31;	matrixresult.x31 = matrixconv.x30;
	matrixresult.x32 = matrixconv.x32;	matrixresult.x33 = matrixconv.x33;


	//data bit convert, 1 bit  sign, 2 bit integer, 10 bits fractrional for coefficient; 1 bit sign,9 bit integer, 4 bit fractional for constant
	//range limited
	iDE_SCAL_Csc_Lmt(&matrixresult.x00, -8191, 8191, 0, 16383);
	iDE_SCAL_Csc_Lmt(&matrixresult.x01, -8191, 8191, 0, 16383);
	iDE_SCAL_Csc_Lmt(&matrixresult.x02, -8191, 8191, 0, 16383);
	iDE_SCAL_Csc_Lmt(&matrixresult.x03, -16383, 16383, 6, 32767);
	iDE_SCAL_Csc_Lmt(&matrixresult.x10, -8191, 8191, 0, 16383);
	iDE_SCAL_Csc_Lmt(&matrixresult.x11, -8191, 8191, 0, 16383);
	iDE_SCAL_Csc_Lmt(&matrixresult.x12, -8191, 8191, 0, 16383);
	iDE_SCAL_Csc_Lmt(&matrixresult.x13, -16383, 16383, 6, 32767);
	iDE_SCAL_Csc_Lmt(&matrixresult.x20, -8191, 8191, 0, 16383);
	iDE_SCAL_Csc_Lmt(&matrixresult.x21, -8191, 8191, 0, 16383);
	iDE_SCAL_Csc_Lmt(&matrixresult.x22, -8191, 8191, 0, 16383);
	iDE_SCAL_Csc_Lmt(&matrixresult.x23, -16383, 16383, 6, 32767);
	
    //write csc register
    pt = &(matrixresult.x00);

	for(i=0;i<4;i++)
	{
		DE_BE_WUINT32(sel, DE_BE_OUT_COLOR_G_COEFF_OFF+ 4*i, *(pt + i));
		DE_BE_WUINT32(sel, DE_BE_OUT_COLOR_R_COEFF_OFF+ 4*i, *(pt + 4 + i));
		DE_BE_WUINT32(sel, DE_BE_OUT_COLOR_B_COEFF_OFF+ 4*i, *(pt + 8 + i));
	}
	
    return 0;
}

__s32 DE_BE_enhance_enable(__u32 sel, __bool enable)
{
    DE_BE_WUINT32(sel, DE_BE_OUT_COLOR_CTRL_OFF, enable);

    return 0;
}

__s32 DE_BE_deflicker_enable(__u32 sel, __bool enable)
{
	DE_BE_WUINT32(sel, DE_BE_MODE_CTL_OFF,(DE_BE_RUINT32(sel, DE_BE_MODE_CTL_OFF)&(~(1<<4))) | (enable<<4));
	
    return 0;
}


__s32 DE_BE_output_csc_enable(__u32 sel, __bool enable)
{
	DE_BE_WUINT32(sel, DE_BE_MODE_CTL_OFF,(DE_BE_RUINT32(sel, DE_BE_MODE_CTL_OFF)&(~(1<<5))) | (enable<<5));
	
    return 0;
}

__s32 DE_BE_Set_Outitl_enable(__u32 sel, __bool enable)
{
	DE_BE_WUINT32(sel, DE_BE_MODE_CTL_OFF,(DE_BE_RUINT32(sel, DE_BE_MODE_CTL_OFF)&(~(1<<28))) | (enable<<28));
	
    return 0;
}

__s32 DE_BE_Output_Cfg_Csc_Coeff(__u32 sel, __bool bout_yuv, __u32 out_color_range)
{
	if(bout_yuv)
	{
		DE_BE_WUINT32(sel, DE_BE_YG_COEFF_OFF + 0, (DE_BE_RUINT32(sel, DE_BE_YG_COEFF_OFF + 0) & 0x0000ffff) | (0x0274<<16));
		DE_BE_WUINT32(sel, DE_BE_YG_COEFF_OFF + 4, (DE_BE_RUINT32(sel, DE_BE_YG_COEFF_OFF + 4) & 0x0000ffff) | (0x00bb<<16));
		DE_BE_WUINT32(sel, DE_BE_YG_COEFF_OFF + 8, (DE_BE_RUINT32(sel, DE_BE_YG_COEFF_OFF + 8) & 0x0000ffff) | (0x003f<<16));
		DE_BE_WUINT32(sel, DE_BE_YG_CONSTANT_OFF , (DE_BE_RUINT32(sel, DE_BE_YG_CONSTANT_OFF) & 0x0000ffff) | (0x0100<<16));
		DE_BE_WUINT32(sel, DE_BE_UR_COEFF_OFF + 0, (DE_BE_RUINT32(sel, DE_BE_UR_COEFF_OFF + 0) & 0x0000ffff) | (0x1ea5<<16));
		DE_BE_WUINT32(sel, DE_BE_UR_COEFF_OFF + 4, (DE_BE_RUINT32(sel, DE_BE_UR_COEFF_OFF + 4) & 0x0000ffff) | (0x1f98<<16));
		DE_BE_WUINT32(sel, DE_BE_UR_COEFF_OFF + 8, (DE_BE_RUINT32(sel, DE_BE_UR_COEFF_OFF + 8) & 0x0000ffff) | (0x01c1<<16));
		DE_BE_WUINT32(sel, DE_BE_UR_CONSTANT_OFF, (DE_BE_RUINT32(sel, DE_BE_UR_CONSTANT_OFF) & 0x0000ffff) | (0x0800<<16));
		DE_BE_WUINT32(sel, DE_BE_VB_COEFF_OFF + 0, (DE_BE_RUINT32(sel, DE_BE_VB_COEFF_OFF + 0) & 0x0000ffff) | (0x1e67<<16));
		DE_BE_WUINT32(sel, DE_BE_VB_COEFF_OFF + 4, (DE_BE_RUINT32(sel, DE_BE_VB_COEFF_OFF + 4) & 0x0000ffff) | (0x01c1<<16));
		DE_BE_WUINT32(sel, DE_BE_VB_COEFF_OFF + 8, (DE_BE_RUINT32(sel, DE_BE_VB_COEFF_OFF + 8) & 0x0000ffff) | (0x1fd7<<16));
		DE_BE_WUINT32(sel, DE_BE_VB_CONSTANT_OFF, (DE_BE_RUINT32(sel, DE_BE_VB_CONSTANT_OFF) & 0x0000ffff) | (0x0800<<16));
		DE_BE_output_csc_enable(sel, 1);
	}
	else 
	{
    	if(out_color_range == DISP_COLOR_RANGE_16_255)
        {
            DE_BE_WUINT32(sel, DE_BE_YG_COEFF_OFF + 0, (DE_BE_RUINT32(sel, DE_BE_YG_COEFF_OFF + 0) & 0x0000ffff) | (0x0000<<16));
            DE_BE_WUINT32(sel, DE_BE_YG_COEFF_OFF + 4, (DE_BE_RUINT32(sel, DE_BE_YG_COEFF_OFF + 4) & 0x0000ffff) | (0x03c4<<16));
            DE_BE_WUINT32(sel, DE_BE_YG_COEFF_OFF + 8, (DE_BE_RUINT32(sel, DE_BE_YG_COEFF_OFF + 8) & 0x0000ffff) | (0x0000<<16));
            DE_BE_WUINT32(sel, DE_BE_YG_CONSTANT_OFF , (DE_BE_RUINT32(sel, DE_BE_YG_CONSTANT_OFF) & 0x0000ffff) | (0x0100<<16));
            DE_BE_WUINT32(sel, DE_BE_UR_COEFF_OFF + 0, (DE_BE_RUINT32(sel, DE_BE_UR_COEFF_OFF + 0) & 0x0000ffff) | (0x03c4<<16));
            DE_BE_WUINT32(sel, DE_BE_UR_COEFF_OFF + 4, (DE_BE_RUINT32(sel, DE_BE_UR_COEFF_OFF + 4) & 0x0000ffff) | (0x0000<<16));
            DE_BE_WUINT32(sel, DE_BE_UR_COEFF_OFF + 8, (DE_BE_RUINT32(sel, DE_BE_UR_COEFF_OFF + 8) & 0x0000ffff) | (0x0000<<16));
            DE_BE_WUINT32(sel, DE_BE_UR_CONSTANT_OFF, (DE_BE_RUINT32(sel, DE_BE_UR_CONSTANT_OFF) & 0x0000ffff) | (0x0100<<16));
            DE_BE_WUINT32(sel, DE_BE_VB_COEFF_OFF + 0, (DE_BE_RUINT32(sel, DE_BE_VB_COEFF_OFF + 0) & 0x0000ffff) | (0x0000<<16));
            DE_BE_WUINT32(sel, DE_BE_VB_COEFF_OFF + 4, (DE_BE_RUINT32(sel, DE_BE_VB_COEFF_OFF + 4) & 0x0000ffff) | (0x0000<<16));
            DE_BE_WUINT32(sel, DE_BE_VB_COEFF_OFF + 8, (DE_BE_RUINT32(sel, DE_BE_VB_COEFF_OFF + 8) & 0x0000ffff) | (0x03c4<<16));
            DE_BE_WUINT32(sel, DE_BE_VB_CONSTANT_OFF, (DE_BE_RUINT32(sel, DE_BE_VB_CONSTANT_OFF) & 0x0000ffff) | (0x0100<<16));
            DE_BE_output_csc_enable(sel, 1);
        }
    	else if(out_color_range == DISP_COLOR_RANGE_16_235)
        {
            DE_BE_WUINT32(sel, DE_BE_YG_COEFF_OFF + 0, (DE_BE_RUINT32(sel, DE_BE_YG_COEFF_OFF + 0) & 0x0000ffff) | (0x0000<<16));
            DE_BE_WUINT32(sel, DE_BE_YG_COEFF_OFF + 4, (DE_BE_RUINT32(sel, DE_BE_YG_COEFF_OFF + 4) & 0x0000ffff) | (0x0370<<16));
            DE_BE_WUINT32(sel, DE_BE_YG_COEFF_OFF + 8, (DE_BE_RUINT32(sel, DE_BE_YG_COEFF_OFF + 8) & 0x0000ffff) | (0x0000<<16));
            DE_BE_WUINT32(sel, DE_BE_YG_CONSTANT_OFF , (DE_BE_RUINT32(sel, DE_BE_YG_CONSTANT_OFF) & 0x0000ffff) | (0x0100<<16));
            DE_BE_WUINT32(sel, DE_BE_UR_COEFF_OFF + 0, (DE_BE_RUINT32(sel, DE_BE_UR_COEFF_OFF + 0) & 0x0000ffff) | (0x0370<<16));
            DE_BE_WUINT32(sel, DE_BE_UR_COEFF_OFF + 4, (DE_BE_RUINT32(sel, DE_BE_UR_COEFF_OFF + 4) & 0x0000ffff) | (0x0000<<16));
            DE_BE_WUINT32(sel, DE_BE_UR_COEFF_OFF + 8, (DE_BE_RUINT32(sel, DE_BE_UR_COEFF_OFF + 8) & 0x0000ffff) | (0x0000<<16));
            DE_BE_WUINT32(sel, DE_BE_UR_CONSTANT_OFF, (DE_BE_RUINT32(sel, DE_BE_UR_CONSTANT_OFF) & 0x0000ffff) | (0x0100<<16));
            DE_BE_WUINT32(sel, DE_BE_VB_COEFF_OFF + 0, (DE_BE_RUINT32(sel, DE_BE_VB_COEFF_OFF + 0) & 0x0000ffff) | (0x0000<<16));
            DE_BE_WUINT32(sel, DE_BE_VB_COEFF_OFF + 4, (DE_BE_RUINT32(sel, DE_BE_VB_COEFF_OFF + 4) & 0x0000ffff) | (0x0000<<16));
            DE_BE_WUINT32(sel, DE_BE_VB_COEFF_OFF + 8, (DE_BE_RUINT32(sel, DE_BE_VB_COEFF_OFF + 8) & 0x0000ffff) | (0x0370<<16));
            DE_BE_WUINT32(sel, DE_BE_VB_CONSTANT_OFF, (DE_BE_RUINT32(sel, DE_BE_VB_CONSTANT_OFF) & 0x0000ffff) | (0x0100<<16));
            DE_BE_output_csc_enable(sel, 1);
        }
    	else
        {
            DE_BE_output_csc_enable(sel, 0);
        }
    }

    return 0;
}

__s32 DE_BE_set_display_size(__u32 sel, __u32 width, __u32 height)
{
    DE_BE_WUINT32(sel, DE_BE_DISP_SIZE_OFF, ((height-1)<<16) | (width-1));
    return 0;
}

__s32 DE_BE_get_display_width(__u32 sel)
{
    __u32 tmp;
    
    tmp = DE_BE_RUINT32(sel, DE_BE_DISP_SIZE_OFF) & 0x0000ffff;

    return tmp + 1;
}

__s32 DE_BE_get_display_height(__u32 sel)
{
    __u32 tmp;
    
    tmp = (DE_BE_RUINT32(sel, DE_BE_DISP_SIZE_OFF) & 0xffff0000)>>16;

    return tmp + 1;
}

__s32 DE_BE_EnableINT(__u8 sel,__u32 irqsrc)
{
    __u32 tmp;

    tmp = DE_BE_RUINT32(sel, DE_BE_INT_EN_OFF);
	DE_BE_WUINT32(sel, DE_BE_INT_EN_OFF, tmp | irqsrc);

	return 0;
}

__s32 DE_BE_DisableINT(__u8 sel, __u32 irqsrc)
{
    __u32 tmp;

    tmp = DE_BE_RUINT32(sel, DE_BE_INT_EN_OFF);
	DE_BE_WUINT32(sel, DE_BE_INT_EN_OFF, tmp & (~irqsrc));

	return 0;
}

__u32 DE_BE_QueryINT(__u8 sel)
{	
	__u32 ret = 0;

	ret = DE_BE_RUINT32(sel, DE_BE_INT_FLAG_OFF);
	
	return ret;
}

__u32 DE_BE_ClearINT(__u8 sel,__u32 irqsrc)
{
	DE_BE_WUINT32(sel, DE_BE_INT_FLAG_OFF,irqsrc);
	
	return 0;
}

